% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{predict_hazard.survival_learner}
\alias{predict_hazard.survival_learner}
\title{Return the fitted hazard coefficient estimate made by a survival learner for
each point in the features.}
\usage{
\method{predict_hazard}{survival_learner}(obj, X, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{...}{Additional arguments (unused)}
}
\description{
A higher hazard coefficient estimate corresponds to a smaller predicted
survival time.
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.0/IAIBase/reference/#IAI.predict_hazard-Tuple\%7BLearner\%7BIAIBase.SurvivalTask\%7D\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict_hazard}}
}
\section{IAI Compatibility}{

Requires IAI version 1.2 or higher.
}

\examples{
\dontrun{iai::predict_hazard(lnr, X)}

}
