% Generated by roxygen2 (4.0.2): do not edit by hand
\name{discounting}
\alias{discounting}
\title{Discounting masses}
\usage{
discounting(MassIn, alpha)
}
\arguments{
\item{MassIn}{Matrix with \eqn{2^n} rows and \eqn{nb} columns. Parameter \eqn{n} is the number of classes and \eqn{nb} is the number of experts.}

\item{alpha}{Discounting factor. A number or a vector with length of \code{ncol(MassIn)}}
}
\value{
Mass matrix. The discounted masses, each column is a piece of mass
}
\description{
Discount masses using  given factors
}
\examples{
## The conflict table for two experts in a discernment frame with three elements
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
discounting(m1,0.95)
# if only one factor is given, all the masses are discounted using the same factor
discounting(cbind(m1,m2),0.95)
# if the factor vector is given, the masses are discounted using the corresponding factor
discounting(cbind(m1,m2),c(0.95,0.9))
}

