% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConflictTable.R
\name{ConflictTable}
\alias{ConflictTable}
\title{Computing the conflict table}
\usage{
ConflictTable(lm, nbexperts)
}
\arguments{
\item{lm}{The length of the power set of the discernment frame, i.e., \eqn{2^{natoms}}}

\item{nbexperts}{The number of experts (masses)}
}
\value{
Matrix with \eqn{nbexperts} rows and number of conflict focal set combinations columns.
}
\description{
Computing the table of conflict for \eqn{nbexperts} masses  and \eqn{natoms = round(\log2(lm))} classes. 
This function gives the conflict focal set combinations for the \eqn{nbexperts} masses. The focal sets are labeled in natural order, e.g, 
number 2 denotes \eqn{\omega_1}, and number 4 donoets \eqn{\{\omega_1,\omega_2\}} if the discernment frame is \eqn{\{\omega_1,\omega_2,\ldots,\omega_n\}}. Note that only one case of 
conflict is given. For example,  if expert 1 says 3, and expert 2 says 2 the function returns \code{matrix(c(2,3),,1)}
 and if expert 1 says 2, and expert 2 says 3 the function also returns \code{matrix(c(2,3),,1)}.
}
\examples{
## The conflict table for two experts in a discernment frame with three elements
 ConflictTable(2^3,2) 
##The conflict table for three experts in a discernment frame with four elements
 ConflictTable(2^4,3) 

}
\seealso{
\code{\link{PCR6}}, \code{\link{decisionDST}}
}
