% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{icd9cm_get_billable}
\alias{icd9cm_get_billable}
\title{Get billable ICD-9-CM codes}
\usage{
icd9cm_get_billable(x, short_code = icd_guess_short(x), invert = FALSE,
  icd9cm_edition = icd9cm_latest_edition())
}
\arguments{
\item{x}{data, e.g. character vector, \code{icd9}, \code{icd9cm}}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{invert}{Single logical value. Returns the inverse of the result. E.g.
if seeking valid ICD-9 codes, the invalid ones are returned.}
}
\description{
Return only those codes which are leaf codes in the hierarchy. In contrast to
\emph{defined} codes, these are considered \emph{billable} and not super-sets
of other codes. The majority have sub-decimal classifications, but some are
simply three-digit codes. This particular function is currently restricted to
ICD-9-CM codes.
}
\keyword{internal}

