% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{icd_count_codes_wide}
\alias{icd_count_codes_wide}
\title{Count ICD codes given in wide format}
\usage{
icd_count_codes_wide(x, visit_name = get_visit_name(x), return_df = FALSE,
  aggr = FALSE)
}
\arguments{
\item{x}{\code{data.frame} with one row per patient, hospital visit,
encounter, etc., and multiple columns containing any ICD codes attributed
to that encounter or patient. i.e. data frame with ICD codes in wide
format.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{return_df}{single logical value, if \code{TRUE}, return the result as a data frame with the first column being
the \code{visit_id}, and the second being the count. If \code{visit_id} was a factor or named differently in the
input, this is preserved.}

\item{aggr}{single logical, default is \code{FALSE}. If \code{TRUE}, the
length (or rows) of the output will no longer match the input, but
duplicate \code{visit_name}s will be counted together.}
}
\description{
For \code{icd_count_codes}, it is assumed that all the columns apart from
\code{visit_name} represent actual or possible ICD-9 codes. Duplicate
\code{visit_name}s are repeated as given and aggregated.
}

