% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{logical_to_binary}
\alias{logical_to_binary}
\alias{binary_to_logical}
\title{Encode \code{TRUE} as 1, and \code{FALSE} as 0 (integers)}
\usage{
logical_to_binary(x)

binary_to_logical(x)
}
\arguments{
\item{x}{\code{data.frame} which may contain logical fields}
}
\value{
\code{data.frame} without logical fields
}
\description{
When saving data as text files for distribution, printing large amounts of
text containing \code{TRUE} and \code{FALSE} is inefficient. Convert to
binary takes more R memory, but allows more compact output
}
\section{Functions}{
\itemize{
\item \code{binary_to_logical}: Convert integer columns to logical values
}}

\examples{
mat <- matrix(sample(c(TRUE, FALSE), size = 9, replace = TRUE), nrow = 3)
mat
icd:::logical_to_binary(mat)
icd:::binary_to_logical(icd:::logical_to_binary(mat))
}
\keyword{internal}
\keyword{logical}
\keyword{manip}
