% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R, R/z-deprecated.R
\name{sort_icd}
\alias{sort_icd}
\alias{sort_icd.default}
\alias{sort_icd.icd10}
\alias{sort_icd.icd9}
\alias{icd_sort.default}
\alias{icd_sort.icd10}
\alias{icd_sort.icd9}
\title{Sort short-form ICD-9 codes}
\usage{
sort_icd(x, ...)

\method{sort_icd}{default}(x, short_code = guess_short(x), ...)

\method{sort_icd}{icd10}(x, short_code = NULL, ...)

\method{sort_icd}{icd9}(x, short_code = guess_short(x), ...)

icd_sort.default(...)

icd_sort.icd10(...)

icd_sort.icd9(...)
}
\arguments{
\item{x}{vector of ICD codes to sort}

\item{...}{arguments passed on to other functions}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{...}{arguments passed on to other functions}

\item{...}{arguments passed on to other functions}
}
\value{
sorted vector of ICD-9 codes. Numeric, then E codes, then V codes.
}
\description{
Sorts lists of numeric only, V or E codes. Note that a simple numeric sort
does not work for ICD-9 codes, since "162" > "1620", and also V codes precede
E codes.
}
\details{
Implementation used fast built-in sort, then shuffles the E codes to
  the end.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Guess whether ICD-9 or ICD-10 (or possibly sub-type in
the future) then sort based on that type. ICD-10 codes, note that setting
\code{short} is unnecessary and ignored.

\item \code{icd10}: Sort ICD-10 codes, note that setting \code{short} is
unnecessary and ignored.

\item \code{icd9}: sort ICD-9 codes respecting numeric, then 'V', then 'E'
codes, and accounting for leading zeroes. Will return a factor if a factor is given.
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the prefix \code{icd::} instead, e.g., \code{icd::charlson}.
  Functions which specifically operate on either ICD-9 or ICD-10 codes or
  their sub-types will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\keyword{internal}
\keyword{manip}
