% Generated by roxygen2 (4.0.1): do not edit by hand
\name{lookupComorbidities}
\alias{lookupComorbidities}
\title{lookup pre-calculated co-morbidities for given list of visit IDs}
\usage{
lookupComorbidities(dat, icd9lk, visitId = "visitId", mergeFun = merge, ...)
}
\arguments{
\item{dat}{contains the data with at least one field named by \code{visitId},
and likely a field "poa" for the present on arrival flag. Additional fields
are preserved. Merging fields with duplicated visitId will behave according
to default of \code{mergeFun}.}

\item{icd9lk}{is one of the pre-prepared lookup tables. e.g.
'comorbidAllInpt','comorbidPoaInpt','comorbidNotPoaInpt' If a character
string is given (vector of unit length), then the name is used to lookup
the data in current environment tree. If a data frame is given, this is
used as the data to lookup co-morbidities for the given}

\item{visitId}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. Defaults to "visitId"}

\item{mergeFun}{is the function used to merge the comorbidity data with the
visitId list, using visitId as the key. Can be left as default \code{merge}
but this has limited ability when identical fields appear, and in how field
name clashes can rename; neither does it report on how effective the merge
was.}

\item{...}{additional arguments passed to \code{mergeFun}}
}
\value{
data.frame with input visit IDs merged with comorbidities
}
\description{
merges the data frame \code{dat} with pre-calculated icd9
  comorbidities by \code{visitId}
}
\keyword{internal}

