% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ValidMapping}
\alias{icd9GetInvalidMappingDecimal}
\alias{icd9GetInvalidMappingShort}
\alias{icd9ValidMapping}
\alias{icd9ValidMappingDecimal}
\alias{icd9ValidMappingShort}
\title{validate an icd9 mapping to comorbidities}
\usage{
icd9ValidMapping(icd9Mapping, isShort)

icd9ValidMappingDecimal(icd9Mapping)

icd9ValidMappingShort(icd9Mapping)

icd9GetInvalidMappingShort(icd9Mapping)

icd9GetInvalidMappingDecimal(icd9Mapping)
}
\arguments{
\item{icd9Mapping}{named list containing vectors of icd9 codes. E.g. the AHRQ comorbidities, contains
\code{list(OBESE = c("2780", "27800", "27801", "27803", "V8554",
"79391", "64910", "64911", "64912", "64913", "64914", "V8530",
"V8531", "V8532", "V8533", "V8534", "V8535", "V8536", "V8537",
"V8538", "V8539", "V8541", "V8542", "V8543", "V8544", "V8545"
),
DEPRESS = c("3004", "30112", "3090", "3091", "311"))} amongst other longer groups.}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}
}
\description{
just takes each item in each vector of the list of vectors and
  checks validity
}
\seealso{
Other ICD9 validation: \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{icd9ValidMajor}},
  \code{\link{icd9ValidMajorE}},
  \code{\link{icd9ValidMajorN}},
  \code{\link{icd9ValidMajorV}};
  \code{\link{icd9ValidNaWarnStop}},
  \code{\link{icd9ValidNaWarnStopDecimal}},
  \code{\link{icd9ValidNaWarnStopMajor}},
  \code{\link{icd9ValidNaWarnStopShort}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}}; \code{\link{icd9Valid}};
  \code{\link{stopIfInvalidIcd9}},
  \code{\link{warnIfInvalidIcd9}}
}

