% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fastIntToStringStd}
\alias{fastIntToStringRcpp}
\alias{fastIntToStringStd}
\title{fast convert integer vector to character vector}
\usage{
fastIntToStringStd(x)

fastIntToStringRcpp(x)
}
\arguments{
\item{x}{td::vector<int>}

\item{bufferSize}{int if any input strings are longer than this number (default 16) there will be memory errors.
No checks done for speed.}
}
\description{
fast convert integer vector to character vector
}
\examples{
\dontrun{
pts <- randomPatients(1e7)
# conclusion: buffer size matters little (so default to be more generous), and Rcpp version fastest.
microbenchmark::microbenchmark(fastIntToStringStd(pts$visitId, buffer = 8),
                               fastIntToStringStd(pts$visitId, buffer = 16),
                               fastIntToStringStd(pts$visitId, buffer = 64),
                               fastIntToStringRcpp(pts$visitId, buffer = 8),
                               fastIntToStringRcpp(pts$visitId, buffer = 16),
                               fastIntToStringRcpp(pts$visitId, buffer = 64),
                               as.character(pts$visitId),
                               asCharacterNoWarn(pts$visitId), times = 5)
}
}
\keyword{internal}

