% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{icd9IsReal}
\alias{icd9GetReal}
\alias{icd9GetRealDecimal}
\alias{icd9GetRealShort}
\alias{icd9IsReal}
\alias{icd9IsRealDecimal}
\alias{icd9IsRealShort}
\title{Check whether ICD-9 codes exist}
\usage{
icd9IsReal(icd9, isShort = icd9GuessIsShort(icd9), onlyBillable = FALSE)

icd9IsRealShort(icd9Short, onlyBillable = FALSE)

icd9IsRealDecimal(icd9Decimal, onlyBillable = FALSE)

icd9GetReal(icd9, isShort = icd9GuessIsShort(icd9), onlyBillable = FALSE)

icd9GetRealShort(icd9Short, onlyBillable = FALSE)

icd9GetRealDecimal(icd9Decimal, onlyBillable = FALSE)
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{onlyBillable}{single logical value (default \code{FALSE}), if
\code{TRUE} will divert to test whether the codes are in the billable list
instead of seeing if they are any leaf or branch node.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}
}
\value{
logical vector
}
\description{
This is different from syntactic validity: it looks it up in the
  canonical list of ICD-9 codes published by the CMS, and which are included
  in this package under \code{extdata}. Checking syntactic validity using
  \code{link{icd9IsValid}} etc. is still useful, with a changing list of
  icd-9 codes over time, and possible imperfections in the master lists
  derived from CMS.
}
\section{Functions}{
\itemize{
\item \code{icd9IsRealShort}: Are the given short-form codes defined at heading or
leaf (billable) level?

\item \code{icd9IsRealDecimal}: Are the given decimal-form codes defined at heading or
leaf (billable) level?

\item \code{icd9GetReal}: Return only those codes which are heading or leaf
(billable), specifying whether codes are all short-form or all decimal-form

\item \code{icd9GetRealShort}: Return only those short-form codes which are heading
or leaf (billable)

\item \code{icd9GetRealDecimal}: Return only those decimal-form codes which are heading
or leaf (billable)
}}

