% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vms.R
\name{get_vms}
\alias{get_vms}
\title{Download VMS data}
\usage{
get_vms(
  country,
  year,
  month,
  c_square,
  gear_code,
  metier,
  stat_rec,
  ices_area,
  ecoregion,
  datacall = NULL
)
}
\arguments{
\item{country}{country code}

\item{year}{integer year}

\item{month}{integer month}

\item{c_square}{character 0.05 degree c-square name}

\item{gear_code}{benthis gear code}

\item{metier}{level 6 metier code}

\item{stat_rec}{ICES statistical rectangle}

\item{ices_area}{ICES area}

\item{ecoregion}{ICES ecoregion}

\item{datacall}{integer year giving which data call year to inquire about.
If NULL returns the a summary of the most recent approved data.}
}
\value{
a data.frame of VMS data
}
\description{
RESTRICTED.  Only core members of the ICES VMS data call can access this data.
Download a data.frame of VMS data from the ICES VMS and logbook database.
}
\examples{
\dontrun{
# requires authorization
vms <- get_vms(country = "DK", year = 2021, month = 1)
}

}
