% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodeList.R
\name{getCodeList}
\alias{getCodeList}
\title{Get Codes}
\usage{
getCodeList(code_type, date = NULL)
}
\arguments{
\item{code_type}{the code type, e.g. SpecWoRMS.}

\item{date}{restrict output to codes modified after a given date in
yyyy-mm-dd format, e.g. "2010-12-01".}
}
\value{
A data frame.
}
\description{
Get codes of a given code type.
}
\examples{
\dontrun{
# Aphia Species codes
findCodeType("aphia", full = TRUE)
codes <- getCodeList("SpecWoRMS")
head(codes)

findAphia("cod", full = TRUE)
}
}
\seealso{
\code{\link{getCodeTypeList}} and \code{\link{getCodeDetail}} get code types
and code details.

\code{\link{findCodeType}} and \code{\link{findAphia}} provide support for searching the code type and code lists.

\code{\link{icesVocab-package}} gives an overview of the package.
}
