% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{iplot}
\alias{iplot}
\title{iplot interactive ichimoku plot}
\usage{
iplot(x, from, to, ticker, theme = "default", gaps = FALSE, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{from}{(optional) a starting date/time to subset the plot.}

\item{to}{(optional) an ending date/time to subset the plot.}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{theme}{with a default of 'default'. This can also be set to 'dark' or
'solarized' to select the desired colour scheme.}

\item{gaps}{set to FALSE by default to remove weekend and holiday gaps. Set
to TRUE for a continuous timescale axis, but with gaps for non-trading
days.}

\item{...}{other arguments to be passed along.}
}
\value{
Returns a plotly object with classes 'plotly' and 'htmlwidget'.
}
\description{
Plot interactive Ichimoku Kinko Hyo cloud charts from ichimoku objects.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
\donttest{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

iplot(cloud)
iplot(cloud, from = "2020-05-15", to = "2020-10-30", theme = "dark")
iplot(cloud, ticker = "TKR Co.", theme = "solarized", gaps = TRUE)
}

}
