% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku-package.R
\docType{package}
\encoding{UTF-8}
\name{ichimoku-package}
\alias{ichimoku-package}
\title{ichimoku: Visualization and Tools for Ichimoku Kinko Hyo Strategies}
\description{
An implementation of 'Ichimoku Kinko Hyo', also commonly known as 'cloud
    charts'. Static and interactive visualizations with tools for creating,
    backtesting and development of quantitative 'ichimoku' strategies. As
    described in Sasaki (1996, ISBN:4925152009), the technique is a refinement
    on candlestick charting, originating from Japan and now in widespread use
    in technical analysis worldwide. Translating as 'one-glance equilibrium
    chart', it allows the price action and market structure of financial
    securities to be determined 'at-a-glance'. Incorporates an interface with
    the OANDA fxTrade API \url{https://developer.oanda.com/} for retrieving
    historical and live streaming price data for major currencies, metals,
    commodities, government bonds and stock indices.
}
\section{Principal ichimoku functions}{

Data & Visualization
\itemize{
    \item{\code{\link{ichimoku}}} {to create an ichimoku object from price
    data.}
    \item{\code{\link{plot.ichimoku}} / \code{\link{iplot}}} {to plot
    (interactive) cloud charts from ichimoku objects.}
    \item{\code{\link{archive}}} {for reading/writing objects to/from archive
    files with data verification.}
    \item{\code{\link{oanda}}} {to retrieve price data from the OANDA fxTrade
    API.}
}
Strategies & ML
\itemize{
    \item{\code{\link{strat}}} {to augment an ichimoku object with a strategy,
    including combined and asymmetric strategies.}
    \item{\code{\link{stratcombine}}} {to create custom combined strategies.}
    \item{\code{\link{autostrat}}} {to automatically evaluate and rank
    top-performing strategies.}
    \item{\code{\link{mlgrid}}} {to generate a numeric representation of the
    relationship between ichimoku cloud chart elements.}
}
Real-time
\itemize{
    \item{\code{\link{oanda_chart}}} {to plot real-time ichimoku cloud
    charts using OANDA data.}
    \item{\code{\link{oanda_studio}}} {a complete live analysis environment
    using OANDA data implemented in R Shiny.}
    \item{\code{\link{oanda_stream}} / \code{\link{oanda_quote}}} {to obtain
    the latest live data stream / quote from the OANDA fxTrade API.}
    \item{\code{\link{oanda_view}}} {for a market overview showing the
    relative performance of constituents.}
}
}

\references{
Sasaki, H. (1996), \emph{ichimoku kinkouhyou no kenkyuu}. Tokyo,
    Japan: Toushi Radar.

    OANDA' and 'fxTrade' are trademarks owned by OANDA Corporation, an entity
    unaffiliated with the ichimoku package.

    Gao, C. (2021), \emph{ichimoku: Visualization and Tools for Ichimoku
    Kinko Hyo Strategies}. R package version 1.2.2,
    \url{https://CRAN.R-project.org/package=ichimoku}.
}
\author{
Charlie Gao \email{charlie.gao@shikokuchuo.net}
    (\href{https://orcid.org/0000-0002-0750-061X}{ORCID})
}
