% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_studio}
\alias{oanda_studio}
\title{OANDA Studio Interactive Live Analysis}
\usage{
oanda_studio(
  instrument = "USD_JPY",
  granularity = c("D", "W", "M", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30", "M15",
    "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5"),
  refresh = 5,
  count = 300,
  price = c("M", "B", "A"),
  theme = c("classic", "dark", "mono", "noguchi", "okabe-ito", "solarized"),
  type = c("none", "r", "s"),
  server,
  apikey,
  new.process = FALSE,
  ...,
  launch.browser = TRUE,
  periods = c(9L, 26L, 52L)
)
}
\arguments{
\item{instrument}{[default 'USD_JPY'] string containing the base currency and
quote currency delimited by a '_'. Use the \code{\link{oanda_instruments}}
function to return a list of all valid instruments.}

\item{granularity}{[default "D"] the granularity of the price data to fetch,
one of "M", "W", "D", "H12", "H8", "H6", "H4", "H3", "H2", "H1", "M30",
"M15", "M10", "M5", "M4", "M2", "M1", "S30", "S15", "S10", "S5".}

\item{refresh}{[default 5] data refresh interval in seconds, with a minimum
of 1.}

\item{count}{[default 300] the number of periods to return, from 100 to 800.
Note that fewer periods are actually shown on the chart to ensure a full
cloud is always displayed.}

\item{price}{[default "M"] pricing component, one of "M" (midpoint), "B" (bid)
or "A" (ask).}

\item{theme}{[default 'original'] with alternative choices of 'conceptual',
'dark', 'fresh', 'mono', or 'solarized'.}

\item{type}{[default 'none'] type of sub-plot to display beneath the ichimoku
cloud chart, with a choice of 'none', 'r' or 's' for the corresponding
oscillator type.}

\item{server}{(optional) specify the "practice" or "live" server according to
the account type held. If not specified, will default to "practice", unless
this has been changed by \code{\link{oanda_switch}}.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}

\item{new.process}{[default FALSE] if TRUE, will start the shiny session in a
new R process, unblocking the current process and allowing continued use
of the R console.}

\item{...}{additional arguments passed along to \code{\link{ichimoku}} for
calculating the ichimoku cloud, \code{\link{autoplot}} to set chart
parameters, or the 'options' argument of \code{shiny::shinyApp()}.}

\item{launch.browser}{[default TRUE] If TRUE, the system's default web browser
will be launched automatically after the app is started. The value of this
argument can also be a function to call with the application's URL. To use
the default Shiny viewer in RStudio, please specify
\code{getOption("shiny.launch.browser")}.}

\item{periods}{[default c(9L, 26L, 52L)] a vector defining the length of
periods used for the cloud. This parameter shoud not normally be modified
as using other values would be invalid in the context of traditional
ichimoku analysis.}
}
\value{
A Shiny app object with class 'shiny.appobj'. With default arguments,
    the Shiny app is launched in the default browser.
}
\description{
Interactive and fully-customisable R Shiny environment providing real-time
    Ichimoku Kinko Hyo cloud charts for major currencies, metals, commodities,
    government bonds and stock indices using OANDA fxTrade API data. Intuitive
    cursor infotip provides ready access to the data directly from the chart.
}
\details{
This function polls the OANDA fxTrade API for the latest prices and
    updates a customisable reactive Shiny app at each refresh interval.

    This function has a dependency on the 'shiny' package.
}
\section{Further Details}{

    Please refer to the OANDA fxTrade API vignette by calling:
    \code{vignette("xoanda", package = "ichimoku")}.
}

\examples{
\dontrun{
# OANDA fxTrade API key required to run these examples
oanda_studio()

# To open in RStudio viewer instead of default browser
oanda_studio(launch.browser = getOption("shiny.launch.browser"))
}

}
