% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency_algorithms.R
\name{SeqKL}
\alias{SeqKL}
\title{Sequential Kullback-Leibler based algorithm for the MNL model.}
\usage{
SeqKL(cand.set, n.alts, alt.cte, par.draws, weights, reduce = TRUE)
}
\arguments{
\item{cand.set}{A numeric matrix in which each row is a possible profile. The
\code{\link{Profiles}} function can be used to generate this.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{alt.cte}{A binary vector indicating for each alternative if an
alternative specific constant is desired.}

\item{par.draws}{A matrix in which each row is a sample from the
multivariate parameter distribution. See also \code{\link{ImpsampMNL}}.}

\item{weights}{A vector containing the weights of the samples. Default is
\code{NULL}, See also \code{\link{ImpsampMNL}}.}

\item{reduce}{Logical value indicating whether the candidate set should be
reduced or not.}
}
\value{
\item{set}{Numeric matrix containing the choice set that maximizes the expected KL divergence.}
\item{kl}{Numeric value which is the Kullback leibler divergence.}
}
\description{
Selects the choice set that maximizes the Kullback-Leibler divergence between
prior parameter values and the expected posterior, assuming an MNL model.
}
\details{
The algorithm selects the choice set that maximizes the Kullback-Leibler
divergence between prior and expected posterior. Otherwisely framed the
algorithm selects the choice set that maximizes the expected information
gain.
}
\examples{
# KL efficient choice set, given parameter samples. 
# Candidate profiles 
cs <- Profiles(lvls = c(3, 3), coding = c("E", "E"))
m <- c(0.3, 0.2, -0.3, -0.2) # Prior mean (4 parameters).
pc <- diag(length(m)) # Prior variance
set.seed(123)
ps <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc) # 10 Samples.
ac <- c(0, 0) # No alternative specific constants. 
# Efficient choice set to add. 
SeqKL(cand.set = cs, n.alts = 2, alt.cte = ac, par.draws = ps, weights = NULL)

# KL efficient choice set, given parameter samples. 
# Candidate profiles 
cs <- Profiles(lvls = c(3, 3), coding = c("C", "E"), c.lvls = list(c(5,3,1)))
m <- c(0.7, 0.3, -0.3, -0.2) # Prior mean (4 parameters).
pc <- diag(length(m)) # Prior variance
set.seed(123)
ps <- MASS::mvrnorm(n = 10, mu = m, Sigma = pc) # 10 Samples.
ac <- c(1, 0) # Alternative specific constant. 
# Efficient choice set to add. 
SeqKL(cand.set = cs, n.alts = 2, alt.cte = ac, par.draws = ps, weights = NULL)
}
\references{
\insertRef{crabbe}{mnldes}
}
