% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{fit.model}
\alias{fit.model}
\title{Model fitting}
\usage{
fit.model(data.all = NULL, lst.var = NULL)
}
\arguments{
\item{data.all}{Original dataset}

\item{lst.var}{see \code{\link{idem-parameters}}}
}
\value{
A class \code{idem.fit} list of modeling fitting results from each model with the following
    items
\describe{
  \item{lm}{results from function \code{lm}}
  \item{formula}{model formula}
  \item{coef}{model coefficients}
  \item{res}{residuals}
  \item{h}{bandwidth of residuals for kernel density estimation}
}
}
\description{
Fit linear imputation models to the observed data from complete survivors for
each treatment arm at each time point
}
\examples{

lst.var <- list(trt="TRT", outcome=c("Y1","Y2"),
                y0=NULL, cov=c("AGE"), bounds=c(0,100));

rst.fit <- fit.model(abc, lst.var)

}

