% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_to_age_model.R
\name{combine_to_age_model}
\alias{combine_to_age_model}
\title{Combine an Infectious Disease Model To a Demographic Model}
\usage{
combine_to_age_model(
  df,
  age_com = NULL,
  compartments = NULL,
  hold_out_var = NULL,
  total_pop = TRUE
)
}
\arguments{
\item{df}{A dataframe of model output.}

\item{age_com}{Integer indicating the number of age compartments.}

\item{compartments}{A character vector of the disease model compartments to combine.}

\item{hold_out_var}{A character vector specifying the variables to keep unchanged. Defaults to NULL}

\item{total_pop}{A logical indicating whether to calculate the total population. Defaults
to true.}
}
\value{
A dataframe which summarises the demographic process of a model.
}
\description{
Similarly to \code{\link[idmodelr]{combine_strat_model_output}} this functions
reduces the dimension of model output into just the demographic components.
}
\examples{

df <- data.frame(S1 = c(1,2), S2 = c(1, 3), E1 = c(4, 1), E2 = c(3, 4), time = c(1, 2))

combine_to_age_model(df, age_com = 2, hold_out_var = "time")
}
\seealso{
combine_strat_model_output
}
