% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/righttri.R
\encoding{UTF-8}
\name{righttri}
\alias{righttri}
\title{Right triangle calculations}
\source{
\enumerate{
   \item r - Better error message for stopifnot? - Stack Overflow answered by Andrie on Dec 1 2011. See \url{http://stackoverflow.com/questions/8343509/better-error-message-for-stopifnot}.
   \item r - switch() statement usage - Stack Overflow answered by Tommy on Oct 19 2011 and edited by Tommy on Mar 6 2012. See \url{http://stackoverflow.com/questions/7825501/switch-statement-usage}.
   \item Using Switch Statement in R - Stack Overflow answered by Gavin Simpson on Jul 25 2013. See \url{http://stackoverflow.com/questions/17847034/using-switch-statement-in-r}.
}
}
\usage{
righttri(a = NULL, b = NULL, c = NULL)
}
\arguments{
\item{a}{numeric vector that contains the known side a, if known}

\item{b}{numeric vector that contains the known side b, if known}

\item{c}{numeric vector that contains the known side c (hypotenuse),
if known}
}
\value{
\code{\link[base]{list}} of known sides a, b, and c & the interior angles
  A, B, and C (right angle), in degrees, if and only if the given
  sides create a right triangle.
}
\description{
This function computes the missing length (must have at least 2 sides) and
the interior angles (degrees) of a right triangle.
}
\details{
Side \code{a} is the side adjacent to angle B and opposite angle A. Side \code{b}
  is the side adjacent to angle A and opposite angle B. Side c (hypotenuse)
  is opposite the right angle (angle C).

This function makes the following calculations:
\enumerate{
   \item the length of the missing side using the Pythagorean theorem,
   \item the area of the right triangle,
   \item the altitude of the right triangle,
   \item the angle associated with the side named a (degrees),
   \item the angle associated with the side named b (degrees), and
   \item the angle associated with the side named c (degrees).
}
}
\examples{
library("iemisc")
\dontrun{
righttri(0, 2) # a = 0, b = 2

righttri(1, 2) # a = 1, b = 2

righttri(a = 5, c = 10)

righttri(a = 3, c = 5)

righttri(a = 5, c = 10)
}




}
\references{
\enumerate{
   \item r - Better error message for stopifnot? - Stack Overflow answered by Andrie on Dec 1 2011. See \url{http://stackoverflow.com/questions/8343509/better-error-message-for-stopifnot}.
   \item Masoud Olia, Ph.D., P.E. and Contributing Authors, \emph{Barron’s FE (Fundamentals of Engineering Exam)}, 3rd Edition, Hauppauge, New York: Barron’s Educational Series, Inc., 2015, page 44-45.
   \item Wikimedia Foundation, Inc. Wikipedia, 28 December 2015, “Pythagorean theorem”, \url{https://en.wikipedia.org/wiki/Pythagorean_theorem}.
   \item Wikimedia Foundation, Inc. Wikipedia, 26 November 2015, “Radian”, \url{https://en.wikipedia.org/wiki/Radian}.
   \item Wikimedia Foundation, Inc. Wikipedia, 9 December 2015, “Right triangle”, \url{https://en.wikipedia.org/wiki/Right_triangle}.
}
}
