% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rem.R
\encoding{UTF-8}
\name{Rem}
\alias{Rem}
\title{Remainder After Division (GNU Octave/MATLAB compatible)}
\usage{
Rem(x, n)
}
\arguments{
\item{x, n}{An R object (array, matrix, vector)}
}
\value{
"Return the remainder of the division x / y." Source: Eaton.
}
\description{
Obtain the remainder after division in a manner compatible with GNU
Octave/MATLAB.
}
\examples{

# Example from GNU Octave

library(iemisc)

x <- 23.4
y <- 20

Rem(x, y)


# Please refer to the iemisc: Examples from GNU Octave Rem, Mod, and
# fractdiff Compatible Functions vignette for additional examples



}
\references{
\enumerate{
   \item Samit Basu (2002-2006). FreeMat v4.0, \url{https://freemat.sourceforge.net/help/mathfunctions_rem.html}.
   \item John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 564.
}
}
\author{
Irucka Embry, Samit Basu (FreeMat)
}
