% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.common.R
\name{curve_multiple}
\alias{autocurve.edges}
\alias{curve_multiple}
\title{Optimal edge curvature when plotting graphs}
\usage{
curve_multiple(graph, start = 0.5)
}
\arguments{
\item{graph}{The input graph.}

\item{start}{The curvature at the two extreme edges. All edges will have a
curvature between \code{-start} and \code{start}, spaced equally.}
}
\value{
A numeric vector, its length is the number of edges in the graph.
}
\description{
If graphs have multiple edges, then drawing them as straight lines does not
show them when plotting the graphs; they will be on top of each other. One
solution is to bend the edges, with diffenent curvature, so that all of them
are visible.
}
\details{
\code{curve_multiple} calculates the optimal \code{edge.curved} vector for
plotting a graph with multiple edges, so that all edges are visible.
}
\examples{
g <- graph( c(0,1,1,0,1,2,1,3,1,3,1,3,
              2,3,2,3,2,3,2,3,0,1)+1 )

curve_multiple(g)

\dontrun{
set.seed(42)
plot(g)
}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{igraph.plotting}} for all plotting parameters,
\code{\link{plot.igraph}}, \code{\link{tkplot}} and \code{\link{rglplot}}
for plotting functions.
}
\keyword{graphs}

