% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hrg.R
\name{hrg}
\alias{hrg}
\alias{hrg.create}
\title{Create a hierarchical random graph from an igraph graph}
\usage{
hrg(graph, prob)
}
\arguments{
\item{graph}{The igraph graph to create the HRG from.}

\item{prob}{A vector of probabilities, one for each vertex, in the order of
vertex ids.}
}
\value{
\code{hrg} returns an \code{igraphHRG} object.
}
\description{
\code{hrg} creates a HRG from an igraph graph. The igraph graph must be
a directed binary tree, with \eqn{n-1} internal and \eqn{n} leaf
vertices. The \code{prob} argument contains the HRG probability labels
for each vertex; these are ignored for leaf vertices.
}
\seealso{
Other hierarchical random graph functions: \code{\link{consensus_tree}},
  \code{\link{hrg.consensus}}; \code{\link{fit_hrg}},
  \code{\link{hrg.fit}}; \code{\link{hrg-methods}};
  \code{\link{hrg.game}}, \code{\link{sample_hrg}};
  \code{\link{hrg.predict}}, \code{\link{predict_edges}};
  \code{\link{hrg_tree}};
  \code{\link{print.igraphHRGConsensus}};
  \code{\link{print.igraphHRG}}
}

