% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attributes.R
\name{igraph-dollar}
\alias{$.igraph}
\alias{$<-.igraph}
\alias{igraph-dollar}
\title{Getting and setting graph attributes, shortcut}
\usage{
\method{$}{igraph}(x, name)

\method{$}{igraph}(x, name) <- value
}
\arguments{
\item{x}{An igraph graph}

\item{name}{Name of the attribute to get/set.}

\item{value}{New value of the graph attribute.}
}
\description{
The \code{$} operator is a shortcut to get and and set
graph attributes. It is shorter and just as readable as
\code{\link{graph_attr}} and \code{\link{set_graph_attr}}.
}
\examples{
g <- make_ring(10)
g$name
g$name <- "10-ring"
g$name
}
\seealso{
Other graph attributes: \code{\link{$.igraph.vs}},
  \code{\link{$<-.igraph.vs}}, \code{\link{V<-}},
  \code{\link{[<-.igraph.vs}},
  \code{\link{[[<-.igraph.vs}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}};
  \code{\link{attributes}}, \code{\link{graph_attr_names}},
  \code{\link{list.graph.attributes}};
  \code{\link{delete_edge_attr}},
  \code{\link{remove.edge.attribute}};
  \code{\link{delete_graph_attr}},
  \code{\link{remove.graph.attribute}};
  \code{\link{delete_vertex_attr}},
  \code{\link{remove.vertex.attribute}};
  \code{\link{edge.attributes<-}},
  \code{\link{edge_attr<-}}; \code{\link{edge.attributes}},
  \code{\link{edge_attr}},
  \code{\link{get.edge.attribute}};
  \code{\link{edge_attr_names}},
  \code{\link{list.edge.attributes}};
  \code{\link{get.graph.attribute}},
  \code{\link{graph.attributes}}, \code{\link{graph_attr}};
  \code{\link{get.vertex.attribute}},
  \code{\link{vertex.attributes}},
  \code{\link{vertex_attr}};
  \code{\link{graph.attributes<-}},
  \code{\link{graph_attr<-}};
  \code{\link{list.vertex.attributes}},
  \code{\link{vertex_attr_names}};
  \code{\link{set.edge.attribute}},
  \code{\link{set_edge_attr}};
  \code{\link{set.graph.attribute}},
  \code{\link{set_graph_attr}};
  \code{\link{set.vertex.attribute}},
  \code{\link{set_vertex_attr}};
  \code{\link{vertex.attributes<-}},
  \code{\link{vertex_attr<-}}
}

