% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{constraint}
\alias{constraint}
\title{Burt's constraint}
\usage{
constraint(graph, nodes = V(graph), weights = NULL)
}
\arguments{
\item{graph}{A graph object, the input graph.}

\item{nodes}{The vertices for which the constraint will be calculated.
Defaults to all vertices.}

\item{weights}{The weights of the edges. If this is \code{NULL} and there is
a \code{weight} edge attribute this is used. If there is no such edge
attribute all edges will have the same weight.}
}
\value{
A numeric vector of constraint scores
}
\description{
Given a graph, \code{constraint} calculates Burt's constraint for each
vertex.
}
\details{
Burt's constraint is higher if ego has less, or mutually
stronger related (i.e. more redundant) contacts. Burt's measure of
constraint, \eqn{C_i}{C[i]}, of vertex \eqn{i}'s ego network
\eqn{V_i}{V[i]}, is defined for directed and valued graphs,
\deqn{C_i=\sum_{j \in V_i \setminus \{i\}} (p_{ij}+\sum_{q \in V_i
    \setminus \{i,j\}} p_{iq} p_{qj})^2}{
  C[i] = sum( [sum( p[i,j] + p[i,q] p[q,j], q in V[i], q != i,j )]^2, j in
  V[i], j != i).
}
for a graph of order (ie. number of vertices) \eqn{N}, where
proportional tie strengths are defined as
\deqn{p_{ij} = \frac{a_{ij}+a_{ji}}{\sum_{k \in V_i \setminus \{i\}}(a_{ik}+a_{ki})},}{
  p[i,j]=(a[i,j]+a[j,i]) / sum(a[i,k]+a[k,i], k in V[i], k != i),
}
\eqn{a_{ij}}{a[i,j]} are elements of \eqn{A} and the latter being the
graph adjacency matrix. For isolated vertices, constraint is undefined.
}
\examples{
g <- sample_gnp(20, 5/20)
constraint(g)
}
\author{
Jeroen Bruggeman
(\url{https://sites.google.com/site/jebrug/jeroen-bruggeman-social-science})
and Gabor Csardi \email{csardi.gabor@gmail.com}
}
\references{
Burt, R.S. (2004). Structural holes and good ideas.
\emph{American Journal of Sociology} 110, 349-399.
}
\keyword{graphs}

