% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R, R/make.R
\name{is_bipartite}
\alias{is_bipartite}
\alias{make_bipartite_graph}
\alias{graph.bipartite}
\alias{is.bipartite}
\alias{is_bipartite}
\alias{bipartite_graph}
\title{Create a bipartite graph}
\usage{
is_bipartite(graph)

make_bipartite_graph(types, edges, directed = FALSE)

bipartite_graph(...)
}
\arguments{
\item{graph}{The input graph.}

\item{types}{A vector giving the vertex types. It will be coerced into
boolean. The length of the vector gives the number of vertices in the graph.}

\item{edges}{A vector giving the edges of the graph, the same way as for the
regular \code{\link{graph}} function. It is checked that the edges indeed
connect vertices of different kind, accoding to the supplied \code{types}
vector.}

\item{directed}{Whether to create a directed graph, boolean constant. Note
that by default undirected graphs are created, as this is more common for
bipartite graphs.}

\item{...}{Passed to \code{make_bipartite_graph}.}
}
\value{
\code{make_bipartite_graph} returns a bipartite igraph graph. In other
words, an igraph graph that has a vertex attribute named \code{type}.

\code{is_bipartite} returns a logical scalar.
}
\description{
A bipartite graph has two kinds of vertices and connections are only allowed
between different kinds.
}
\details{
Bipartite graphs have a \code{type} vertex attribute in igraph, this is
boolean and \code{FALSE} for the vertices of the first kind and \code{TRUE}
for vertices of the second kind.

\code{make_bipartite_graph} basically does three things. First it checks tha
\code{edges} vector against the vertex \code{types}. Then it creates a graph
using the \code{edges} vector and finally it adds the \code{types} vector as
a vertex attribute called \code{type}.

\code{is_bipartite} checks whether the graph is bipartite or not. It just
checks whether the graph has a vertex attribute called \code{type}.
}
\examples{

g <- make_bipartite_graph( rep(0:1,length=10), c(1:10))
print(g, v=TRUE)

}
\seealso{
\code{\link{graph}} to create one-mode networks
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
