% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{edge_density}
\alias{edge_density}
\alias{graph.density}
\title{Graph density}
\usage{
edge_density(graph, loops = FALSE)
}
\arguments{
\item{graph}{The input graph.}

\item{loops}{Logical constant, whether to allow loop edges in the graph. If
this is TRUE then self loops are considered to be possible. If this is FALSE
then we assume that the graph does not contain any loop edges and that loop
edges are not meaningful.}
}
\value{
A real constant. This function returns \code{NaN} (=0.0/0.0) for an
empty graph with zero vertices.
}
\description{
The density of a graph is the ratio of the number of edges and the number of
possible edges.
}
\details{
Note that this function may return strange results for graph with multiple
edges, density is ill-defined for graphs with multiple edges.
}
\examples{

g1 <- make_empty_graph(n=10)
g2 <- make_full_graph(n=10)
g3 <- sample_gnp(n=10, 0.4)

# loop edges
g <- graph( c(1,2, 2,2, 2,3) )
edge_density(g, loops=FALSE)              # this is wrong!!!
edge_density(g, loops=TRUE)               # this is right!!!
edge_density(simplify(g), loops=FALSE)    # this is also right, but different

}
\references{
Wasserman, S., and Faust, K.  (1994).  Social Network Analysis:
Methods and Applications.  Cambridge: Cambridge University Press.
}
\seealso{
\code{\link{vcount}}, \code{\link{ecount}}, \code{\link{simplify}}
to get rid of the multiple and/or loop edges.
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
