% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{intersection.igraph.es}
\alias{intersection.igraph.es}
\title{Intersection of edge sequences}
\usage{
\method{intersection}{igraph.es}(...)
}
\arguments{
\item{...}{The edge sequences to take the intersection of.}
}
\value{
An edge sequence that contains edges that appear in all
given sequences, each edge exactly once.
}
\description{
Intersection of edge sequences
}
\details{
They must belong to the same graph. Note that this function has
\sQuote{set} semantics and the multiplicity of edges is lost in the
result.
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
intersection(E(g)[1:6], E(g)[5:9])
}
\seealso{
Other vertex and edge sequence operations: 
\code{\link{c.igraph.es}()},
\code{\link{c.igraph.vs}()},
\code{\link{difference.igraph.es}()},
\code{\link{difference.igraph.vs}()},
\code{\link{igraph-es-indexing2}},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{intersection.igraph.vs}()},
\code{\link{rev.igraph.es}()},
\code{\link{rev.igraph.vs}()},
\code{\link{union.igraph.es}()},
\code{\link{union.igraph.vs}()},
\code{\link{unique.igraph.es}()},
\code{\link{unique.igraph.vs}()}
}
\concept{vertex and edge sequence operations}
