% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{harmonic_centrality}
\alias{harmonic_centrality}
\title{Harmonic centrality of vertices}
\usage{
harmonic_centrality(
  graph,
  vids = V(graph),
  mode = c("out", "in", "all", "total"),
  weights = NULL,
  normalized = FALSE,
  cutoff = -1
)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{vids}{The vertices for which harmonic centrality will be calculated.}

\item{mode}{Character string, defining the types of the paths used for
measuring the distance in directed graphs. \dQuote{out} follows paths along
the edge directions only, \dQuote{in} traverses the edges in reverse, while
\dQuote{all} ignores edge directions. This argument is ignored for undirected
graphs.}

\item{weights}{Optional positive weight vector for calculating weighted
harmonic centrality. If the graph has a \code{weight} edge attribute, then
this is used by default. Weights are used for calculating weighted shortest
paths, so they are interpreted as distances.}

\item{normalized}{Logical scalar, whether to calculate the normalized
harmonic centrality. If true, the result is the mean inverse path length to
other vertices, i.e. it is normalized by the number of vertices minus one.
If false, the result is the sum of inverse path lengths to other vertices.}

\item{cutoff}{The maximum path length to consider when calculating the
harmonic centrality. There is no such limit when the cutoff is negative. Note that
zero cutoff means that only paths of at most length 0 are considered.}
}
\value{
Numeric vector with the harmonic centrality scores of all the vertices in
\code{v}.
}
\description{
The harmonic centrality of a vertex is the mean inverse distance to all other
vertices. The inverse distance to an unreachable vertex is considered to be zero.
}
\details{
The \code{cutoff} argument can be used to restrict the calculation to paths
of length \code{cutoff} or smaller only; this can be used for larger graphs
to speed up the calculation. If \code{cutoff} is negative (which is the
default), then the function calculates the exact harmonic centrality scores.
}
\examples{

g <- make_ring(10)
g2 <- make_star(10)
harmonic_centrality(g)
harmonic_centrality(g2, mode = "in")
harmonic_centrality(g2, mode = "out")
harmonic_centrality(g \%du\% make_full_graph(5), mode = "all")

}
\references{
M. Marchiori and V. Latora, Harmony in the small-world,
\emph{Physica A} 285, pp. 539-546 (2000).
}
\seealso{
\code{\link[=betweenness]{betweenness()}}, \code{\link[=closeness]{closeness()}}

Centrality measures
\code{\link{alpha_centrality}()},
\code{\link{closeness}()},
\code{\link{diversity}()},
\code{\link{eigen_centrality}()},
\code{\link{estimate_betweenness}()},
\code{\link{hub_score}()},
\code{\link{page_rank}()},
\code{\link{power_centrality}()},
\code{\link{spectrum}()},
\code{\link{strength}()},
\code{\link{subgraph_centrality}()}
}
\concept{centrality}
\keyword{graphs}
