% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{sample_}
\alias{sample_}
\title{Sample from a random graph model}
\usage{
sample_(...)
}
\arguments{
\item{...}{Parameters, see details below.}
}
\description{
Generic function for sampling from network models.
}
\details{
TODO
}
\examples{
pref_matrix <- cbind(c(0.8, 0.1), c(0.1, 0.7))
blocky <- sample_(sbm(
  n = 20, pref.matrix = pref_matrix,
  block.sizes = c(10, 10)
))

blocky2 <- pref_matrix \%>\%
  sample_sbm(n = 20, block.sizes = c(10, 10))

## Arguments are passed on from sample_ to sample_sbm
blocky3 <- pref_matrix \%>\%
  sample_(sbm(), n = 20, block.sizes = c(10, 10))
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\concept{games}
