% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_adj_list}
\alias{as_adj_list}
\alias{as_adj_edge_list}
\title{Adjacency lists}
\usage{
as_adj_list(
  graph,
  mode = c("all", "out", "in", "total"),
  loops = c("twice", "once", "ignore"),
  multiple = TRUE
)

as_adj_edge_list(
  graph,
  mode = c("all", "out", "in", "total"),
  loops = c("twice", "once", "ignore")
)
}
\arguments{
\item{graph}{The input graph.}

\item{mode}{Character scalar, it gives what kind of adjacent edges/vertices
to include in the lists. \sQuote{\code{out}} is for outgoing edges/vertices,
\sQuote{\verb{in}} is for incoming edges/vertices, \sQuote{\code{all}} is
for both. This argument is ignored for undirected graphs.}

\item{loops}{Character scalar, one of \code{"ignore"} (to omit loops), \code{"twice"}
(to include loop edges twice) and \code{"once"} (to include them once). \code{"twice"}
is not allowed for directed graphs and will be replaced with \code{"once"}.}

\item{multiple}{Logical scalar, set to \code{FALSE} to use only one representative
of each set of parallel edges.}
}
\value{
A list of \code{igraph.vs} or a list of numeric vectors depending on
the value of \code{igraph_opt("return.vs.es")}, see details for performance
characteristics.
}
\description{
Create adjacency lists from a graph, either for adjacent edges or for
neighboring vertices
}
\details{
\code{as_adj_list()} returns a list of numeric vectors, which include the ids
of neighbor vertices (according to the \code{mode} argument) of all
vertices.

\code{as_adj_edge_list()} returns a list of numeric vectors, which include the
ids of adjacent edges (according to the \code{mode} argument) of all
vertices.

If \code{igraph_opt("return.vs.es")} is true (default), the numeric
vectors of the adjacency lists are coerced to \code{igraph.vs}, this can be
a very expensive operation on large graphs.
}
\examples{

g <- make_ring(10)
as_adj_list(g)
as_adj_edge_list(g)

}
\seealso{
\code{\link[=as_edgelist]{as_edgelist()}}, \code{\link[=as_adj]{as_adj()}}

Other conversion: 
\code{\link{as.directed}()},
\code{\link{as.matrix.igraph}()},
\code{\link{as_adjacency_matrix}()},
\code{\link{as_biadjacency_matrix}()},
\code{\link{as_data_frame}()},
\code{\link{as_edgelist}()},
\code{\link{as_graphnel}()},
\code{\link{as_long_data_frame}()},
\code{\link{graph_from_adj_list}()},
\code{\link{graph_from_graphnel}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{conversion}
\keyword{graphs}
