% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/structural.properties.R
\name{component_distribution}
\alias{component_distribution}
\alias{largest_component}
\alias{components}
\alias{is_connected}
\alias{count_components}
\title{Connected components of a graph}
\usage{
component_distribution(graph, cumulative = FALSE, mul.size = FALSE, ...)

largest_component(graph, mode = c("weak", "strong"))

components(graph, mode = c("weak", "strong"))

is_connected(graph, mode = c("weak", "strong"))

count_components(graph, mode = c("weak", "strong"))
}
\arguments{
\item{graph}{The graph to analyze.}

\item{cumulative}{Logical, if TRUE the cumulative distirubution (relative
frequency) is calculated.}

\item{mul.size}{Logical. If TRUE the relative frequencies will be multiplied
by the cluster sizes.}

\item{\dots}{Additional attributes to pass to \code{cluster}, right now only
\code{mode} makes sense.}

\item{mode}{Character string, either \dQuote{weak} or \dQuote{strong}.  For
directed graphs \dQuote{weak} implies weakly, \dQuote{strong} strongly
connected components to search. It is ignored for undirected graphs.}
}
\value{
For \code{is_connected()} a logical constant.

For \code{components()} a named list with three components:
\item{membership}{numeric vector giving the cluster id to which each vertex
belongs.} \item{csize}{numeric vector giving the sizes of the clusters.}
\item{no}{numeric constant, the number of clusters.}

For \code{count_components()} an integer constant is returned.

For \code{component_distribution()} a numeric vector with the relative
frequencies. The length of the vector is the size of the largest component
plus one. Note that (for currently unknown reasons) the first element of the
vector is the number of clusters of size zero, so this is always zero.

For \code{largest_component()} the largest connected component of the graph.
}
\description{
Calculate the maximal (weakly or strongly) connected components of a graph
}
\details{
\code{is_connected()} decides whether the graph is weakly or strongly
connected. The null graph is considered disconnected.

\code{components()} finds the maximal (weakly or strongly) connected components
of a graph.

\code{count_components()} does almost the same as \code{components()} but returns only
the number of clusters found instead of returning the actual clusters.

\code{component_distribution()} creates a histogram for the maximal connected
component sizes.

\code{largest_component()} returns the largest connected component of a graph. For
directed graphs, optionally the largest weakly or strongly connected component.
In case of a tie, the first component by vertex ID order is returned. Vertex
IDs from the original graph are not retained in the returned graph.

The weakly connected components are found by a simple breadth-first search.
The strongly connected components are implemented by two consecutive
depth-first searches.
}
\examples{

g <- sample_gnp(20, 1 / 20)
clu <- components(g)
groups(clu)
largest_component(g)
}
\seealso{
\code{\link[=decompose]{decompose()}}, \code{\link[=subcomponent]{subcomponent()}}, \code{\link[=groups]{groups()}}

Connected components
\code{\link{articulation_points}()},
\code{\link{biconnected_components}()},
\code{\link{decompose}()}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{components}
\concept{structural.properties}
\keyword{graphs}
