% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_tree}
\alias{make_tree}
\alias{tree}
\title{Create tree graphs}
\usage{
make_tree(n, children = 2, mode = c("out", "in", "undirected"))

tree(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{children}{Integer scalar, the number of children of a vertex
(except for leafs)}

\item{mode}{Defines the direction of the
edges. \code{out} indicates that the edges point from the parent to
the children, \verb{in} indicates that they point from the children
to their parents, while \code{undirected} creates an undirected
graph.}

\item{...}{Passed to \code{make_tree()} or \code{sample_tree()}.}
}
\value{
An igraph graph
}
\description{
Create a k-ary tree graph, where almost all vertices other than the leaves
have the same number of children.
}
\examples{
make_tree(10, 2)
make_tree(10, 3, mode = "undirected")
}
\seealso{
Other deterministic constructors: 
\code{\link{graph_from_atlas}()},
\code{\link{graph_from_edgelist}()},
\code{\link{graph_from_literal}()},
\code{\link{make_}()},
\code{\link{make_chordal_ring}()},
\code{\link{make_empty_graph}()},
\code{\link{make_full_citation_graph}()},
\code{\link{make_full_graph}()},
\code{\link{make_graph}()},
\code{\link{make_lattice}()},
\code{\link{make_ring}()},
\code{\link{make_star}()}
}
\concept{Trees.}
\concept{deterministic constructors}
