% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{add_col_barplot}
\alias{add_col_barplot}
\alias{add_col_barplot,Iheatmap-method}
\title{add_col_barplot}
\usage{
\S4method{add_col_barplot}{Iheatmap}(
  p,
  y,
  ...,
  color = NULL,
  tracename = NA_character_,
  showlegend = !is.na(tracename),
  side = c("top", "bottom"),
  layout = list(),
  size = 0.2,
  buffer = 0.02,
  xname = current_xaxis(p),
  yname = NULL,
  pname = if (!is.na(tracename)) tracename else "col_barplot"
)
}
\arguments{
\item{p}{iheatmap object}

\item{y}{y axis values}

\item{...}{additional arguments to add to plotly scatter trace, see
\url{https://plotly.com/javascript/reference/#scatter}}

\item{color}{color of bars}

\item{tracename}{name of trace (for legend and hover)}

\item{showlegend}{show in legend?}

\item{side}{side of plot on which to add subplot}

\item{layout}{yaxis layout list}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{pname}{internal name of plot}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add bar plot with one bar per column above or below a main heatmap
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_col_barplot(y = 1:5, tracename = "Strength")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_col_signal}}, \code{\link{iheatmap}}, 
\code{\link{add_col_plot}}
}
\author{
Alicia Schep
}
