% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_subplots.R
\name{add_row_plot}
\alias{add_row_plot}
\alias{add_row_plot,Iheatmap-method}
\title{add_row_plot}
\usage{
\S4method{add_row_plot}{Iheatmap}(
  p,
  x,
  ...,
  mode = c("lines+markers", "lines", "markers"),
  color = NULL,
  tracename = NA_character_,
  showlegend = !is.na(tracename),
  side = c("right", "left"),
  layout = list(),
  size = 0.2,
  buffer = 0.02,
  xname = NULL,
  yname = current_yaxis(p),
  pname = if (!is.na(tracename)) tracename else "row_plot"
)
}
\arguments{
\item{p}{iheatmap object}

\item{x}{x axis values}

\item{...}{additional arguments to add to plotly scatter trace, see
\url{https://plotly.com/javascript/reference/#scatter}}

\item{mode}{mode of plot -- one of "lines+markers","lines", or "markers"}

\item{color}{color of bars}

\item{tracename}{name of trace (for legend and hover)}

\item{showlegend}{show in legend?}

\item{side}{side of plot on which to add subplot}

\item{layout}{yaxis layout list}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{pname}{internal name of plot}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
Add a scatter or line plot with one point per row of the main heatmap
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_row_plot(x = 1:4, tracename = "Strength")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_signal}}, \code{\link{iheatmap}}, 
\code{\link{add_row_barplot}}
}
\author{
Alicia Schep
}
