% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/imPois.R
\name{kcpm}
\alias{kcpm}
\title{Bickis and Lee's Conjugate Formula for Imprecise Prior Measure}
\usage{
kcpm(t, xi2, xi1, xi0, ztrunc)
}
\arguments{
\item{t}{numeric value}

\item{xi2}{parameter associated with precision}

\item{xi1}{parameter associated with linear combination}

\item{xi0}{effective sample size}

\item{ztrunc}{a logical value incidcating whether standard Poisson is truncated at 0.}
}
\description{
Bickis and Lee's conjugate formulation is described in the form of three-parameter exponential families.  See \sQuote{Details}.
}
\details{
The formal definition of Bickis and Lee's conjugate formulation is
\deqn{exp(-\xi_2*\theta^2 + \xi_1*\theta + \exp(\theta))}
\eqn{t} is ranged from \code{-Inf} to \code{Inf}.
}
\author{
Chel Hee Lee \email{chl948@mail.usask.ca}
}
\references{
Lee, C.H. (2014) Imprecise Prior for Imprecise Inference on Poisson Sampling Model, PhD Thesis, The Collaborative Biostatistics Program, School of Public Health, University of Saskatchewan
}

