% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textlinedetector.R
\name{image_wordsegmentation}
\alias{image_wordsegmentation}
\title{Find Words by Connected Components Labelling}
\usage{
image_wordsegmentation(x, kernelSize = 11L, sigma = 11L, theta = 7L)
}
\arguments{
\item{x}{an object of class opencv-image containing black/white binary data (type CV_8U1)}

\item{kernelSize}{size of the kernel}

\item{sigma}{sigma of the kernel}

\item{theta}{theta of the kernel}
}
\value{
a list with elements
\itemize{
\item{n: the number of lines found}
\item{overview: an opencv-image of the detected areas}
\item{words: a list of opencv-image's, one for each word area}
}
}
\description{
Filter the image using the gaussian kernel 
and extract components which are connected which are to be considered as words.
}
\examples{
\donttest{
library(opencv)
library(magick)
library(image.textlinedetector)
path  <- system.file(package = "image.textlinedetector", "extdata", "example.png")
img   <- image_read(path)
img   <- image_resize(img, "x1000")
areas <- image_textlines_flor(img, light = TRUE, type = "sauvola")
areas$overview
areas$textlines[[6]]
textwords <- image_wordsegmentation(areas$textlines[[6]])
textwords$n
textwords$overview
textwords$words[[2]]
textwords$words[[3]]
}
}
