% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rotate90}
\alias{rotate90}
\title{Matrix or Array Rotation by 90 Degrees}
\usage{
rotate90(img, direction = "positive")
}
\arguments{
\item{img}{an array or a matrix}

\item{direction}{The direction of rotation by 90 degrees.
The value can be \code{"positive"} (default) or
\code{"negative"}. Aliases are
\code{"counterclockwise"} and \code{"clockwise"},
respectively.}
}
\value{
an array or a matrix (rotated by 90 degrees)
}
\description{
Matrix or Array Rotation by 90 Degrees
}
\details{
The function takes an array or matrix as input
  object (\code{img}) and returns the object rotated by
  90 degrees. Per default, the rotation is done in the
  mathematically positive direction (i.e.,
  counterclockwise). Clockwise rotation (i.e.,
  mathematically negative) can be specified by passing
  the value \code{"negative"} to the \code{direction}
  argument.
}
\examples{
# sample matrix
img <- matrix(1:6, ncol = 2)
img

rotate90(img) # counterclockwise
rotate90(img, direction = "negative") # clockwise
}
