% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{threshold}
\alias{threshold}
\title{Threshold grayscale image}
\usage{
threshold(im, thr, approx = TRUE)
}
\arguments{
\item{im}{the image}

\item{thr}{a threshold, either numeric, or a string with format "XX\%". In the case of the latter, XX will be interpreted as a percentile (set the lower XX\% of the pixels to 0, the rest to 1)}

\item{approx}{Skip pixels when computing quantiles in large images (default TRUE)}
}
\value{
a thresholded image
}
\description{
Thresholding corresponding to setting all values below a threshold to 0, all above to 1. If you call threshold with a string argument of the form "XX%" (e.g., "98%"), the threshold will be set at percentil XX. Computing quantiles is expensive for large images, so if approx == TRUE threshold will skip pixels if the total number of pixels is above 10,000
}
\examples{
im <- load.image(system.file('extdata/Leonardo_Birds.jpg',package='imager'))
grayscale(im) \%>\% threshold("15\%") \%>\% plot
}
\author{
Simon Barthelme
}

