% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{colorise}
\alias{colorise}
\title{Fill in a colour in an area given by a pixset}
\usage{
colorise(im, px, col, alpha = 1)
}
\arguments{
\item{im}{an image}

\item{px}{either a pixset or a formula, as in imeval.}

\item{col}{colour to fill in. either a vector of numeric values or a string (e.g. "red")}

\item{alpha}{transparency (default 1, no transparency)}
}
\value{
an image
}
\description{
Paint all pixels in pixset px with the same colour
}
\examples{
im <- load.example("coins")
colorise(im,Xc(im) < 50,"blue") \%>\% plot
#Same thing with the formula interface
colorise(im,~ x < 50,"blue") \%>\% plot
#Add transparency
colorise(im,~ x < 50,"blue",alpha=.5) \%>\% plot
#Highlight pixels with low luminance values
colorise(im,~ . < 0.3,"blue",alpha=.2) \%>\% plot
}
\author{
Simon Barthelme
}
