% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imglist.R
\name{plot.imlist}
\alias{plot.imlist}
\title{Plot an image list}
\usage{
\method{plot}{imlist}(x, layout = "rect", ...)
}
\arguments{
\item{x}{an image list (of type imlist)}

\item{layout}{either a matrix (in the format defined by the layout command) or one of "row","col" or "rect". Default: "rect"}

\item{...}{other parameters, to be passed to the plot command}
}
\description{
Each image in the list will be plotted separately. The layout argument controls the overall layout of the plot window. The default layout is "rect", which will fit all of your images into a rectangle that's as close to a square as possible.
}
\examples{
imsplit(boats,"c") #Returns an image list
imsplit(boats,"c") \%>\% plot
imsplit(boats,"c") \%>\% plot(layout="row")
imsplit(boats,"c") \%>\% plot(layout="col")
imsplit(boats,"x",5) \%>\% plot(layout="rect")
}
\author{
Simon Barthelme
}
