% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{coord.index}
\alias{coord.index}
\title{Coordinates from pixel index}
\usage{
coord.index(im, index)
}
\arguments{
\item{im}{an image}

\item{index}{a vector of indices}
}
\value{
a data.frame of coordinate values
}
\description{
Compute (x,y,z,cc) coordinates from linear pixel index.
}
\examples{
cind <- coord.index(boats,33)
#Returns (x,y,z,c) coordinates of the 33rd pixel in the array
cind
all.equal(boats[33],with(cind,at(boats,x,y,z,cc)))
all.equal(33,index.coord(boats,cind))
}
\seealso{
index.coord for the reverse operation
}
\author{
Simon Barthelme
}
