% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Shapley.R
\name{plot.Shapley}
\alias{plot.Shapley}
\title{Plot Shapley}
\usage{
\method{plot}{Shapley}(object, sort = TRUE)
}
\arguments{
\item{object}{A Shapley R6 object}

\item{sort}{logical. Should the feature values be sorted by Shapley value? Ignored for multi.class output.}
}
\value{
ggplot2 plot object
}
\description{
plot.Shapley() plots the Shapley values - the contributions of feature values to the prediction.
}
\examples{
if (require("randomForest")) {
# First we fit a machine learning model on the Boston housing data
data("Boston", package  = "MASS")
rf =  randomForest(medv ~ ., data = Boston, ntree = 50)
X = Boston[-which(names(Boston) == "medv")]
mod = Predictor$new(rf, data = X)

# Then we explain the first instance of the dataset with the Shapley method:
x.interest = X[1,]
shapley = Shapley$new(mod, x.interest = x.interest)
plot(shapley)
}
}
\seealso{
\link{Shapley}
}
