% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_replacement.R
\name{codon_replacement}
\alias{codon_replacement}
\title{Replaces codons with synonymous codons}
\usage{
codon_replacement(repertoire, mode = "both", codon_replacement_list,
  skip_probability = 0)
}
\arguments{
\item{repertoire}{An annotated AIRR compliant immuneSIM repertoire.

(http://docs.airr-community.org/en/latest/)}

\item{mode}{Defines whether codons should be replaced in the nt or AA sequence or in both ("nt","AA","both")}

\item{codon_replacement_list}{List containing instructions for which codons should be replaced and how}

\item{skip_probability}{Probability with which a sequence gets skipped in the codon replacement process between 0,1}
}
\value{
immuneSIM repertoire with replaced codons
}
\description{
Replaces codons with synonymous codons
}
\examples{
repertoire <- list_example_repertoires[["example_repertoire_A"]]
rep_codon_repl <- codon_replacement(repertoire, "both",
list(tat = "tac", agt = "agc", gtt = "gtg"), 0)
}
