% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_poblacion_ageb.R
\name{censo_poblacion_ageb}
\alias{censo_poblacion_ageb}
\title{Censo de Poblacion - AGEB}
\usage{
censo_poblacion_ageb(year = 2010, estado = "Nacional",
  totalestado = FALSE, totalmunicipio = FALSE,
  totallocalidad = FALSE, totalageb = FALSE, manzana = TRUE)
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. El unio año disponible en INEGI (incluyendo los conteos) para esta base de datos es 2010.}

\item{estado}{Define el nombre de la entidad federativa para descargar los datos, en formato alfanumerico. Utiliza "Nacional" para descargarlos a nivel nacional. Los nombres de los estados deben ir capitalizados (y en su caso, con espacios), por ejemplo: "Aguascalientes", "CDMX", "San Luis Potosi".}

\item{totalestado}{Resultados agregados a nivel entidad federativa. \code{FALSE} omite los resultados a nivel entidad federativa.}

\item{totalmunicipio}{Resultados agregados a nivel municipio. \code{FALSE} omite los resultados a nivel municipio.}

\item{totallocalidad}{Resultados agregados a nivel localidad urbana. \code{FALSE} omite los resultados a nivel municipio.}

\item{totalageb}{Resultados agregados a nivel AGEB urbana. \code{FALSE} omite los resultados a nivel AGEB.}

\item{manzana}{Si se requiere conservar unicamente los resultados a nivel agregado (p. ej. estado, municipio o localidad), \code{FALSE} eliminara las observaciones por manzana.}
}
\value{
Data.frame
}
\description{
Descarga los datos del Censo de Poblacion y Vivienda al nivel de desagregacion AGEB y manzana urbana.
}
\details{
Esta base de datos tiene tres niveles de agregacion: entidades federativas, municipios, agebs y manzanas (en zonas urbanas).
}
\examples{

# Consultar los datos del Censo a nivel AGEB y manzana urbana.
\donttest{censo_poblacion_ageb()}

# Descargar los datos de CDMX de 2010.
\donttest{ageb = censo_poblacion_ageb(year = 2010, estado = "CDMX")}
}
