% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_marcogeo.R
\name{sig_marcogeo}
\alias{sig_marcogeo}
\title{Marco Geoestadistico Nacional}
\usage{
sig_marcogeo(year = NA, mapa = NA, version = NA)
}
\arguments{
\item{year}{Año de referencia del mapa, en formato numerico. Años disponibles: 1995, 2000, 2005, 2007, 2009, 2010 y 2013.}

\item{mapa}{Mapa en formato alfanumerico. Las opciones son: entidades, municipios, ageb, urbano, y rural.}

\item{version}{Especificar, en formato alfanumerico, la version para los años 2010 (4.3, 5.0, 5.0.A), 2017 (2010.0 o dejar en blanco) y 2018 (2010.0 o dejar en blanco). Para el resto de los años, dejar en blanco.}
}
\value{
Data.frame
}
\description{
Extrae los mapas del Marco Geoestadistico Nacional.
}
\details{
El Marco Geoestadistico Nacional (MGN) es un proyecto geoestadistico que presenta informacion sobre la division política del territorio mexicano en sus diferentes niveles de gobierno (nacional, estatal y municipal), asi como otras formas de clasificacion del territorio nacional.
}
\examples{

# Consultar los metadatos del Marco Geoestadistico Nacional
\dontrun{sig_marcogeo()}

# Descargar el mapa de munucipios para 2009
\dontrun{mapa09 = sig_marcogeo(year = 2009, mapa = "municipios")}
}
