% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_errors.R
\name{plot_errors}
\alias{plot_errors}
\alias{plot_errors.errprof}
\title{Function to plot the Error Comparison}
\usage{
plot_errors(dataIn, ...)

\method{plot_errors}{errprof}(dataIn, plotType = c("boxplot"), ...)
}
\arguments{
\item{dataIn}{an errprof object returned from \code{\link{impute_errors}}}

\item{plotType}{chr string indicating plot type, accepted values are \code{"boxplot"}, \code{"bar"}, or \code{"line"}}

\item{\dots}{arguments passed to or from other methods}
}
\value{
A ggplot object that can be further modified.  The entire range of errors are shown if \code{plotType = "boxplot"}, otherwise the averages are shown if \code{plotType = "bar"} or \code{"line"}.
}
\description{
Function to plot the Error Comparison
}
\examples{
aa <- impute_errors()
plot_errors(aa)
plot_errors(aa, plotType = 'bar')
plot_errors(aa, plotType = 'line')
}

