% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplotExp.R
\name{boxplotExp}
\alias{boxplotExp}
\title{boxplotExp}
\usage{
boxplotExp(x, y, palette, main, selectOrder)
}
\arguments{
\item{x}{A DGEList object from "edgeR".}

\item{y}{Numeric matrix of log-CPM values (genes × samples), e.g., from edgeR::cpm().}

\item{palette}{Character. Name of a discrete palette from the paletteer package.}

\item{main}{Character. Title for the boxplot.}

\item{selectOrder}{Character. Either "Groups" (order samples by group) or "Samples" (order by sample name).}
}
\value{
A ggplot object showing per-sample boxplots of log-CPM values.
}
\description{
Generate a boxplot of log-CPM expression values per sample, colored by group.
}
\details{
This function orders samples by group or sample name, and produces a ggplot2 boxplot
with a horizontal line at the overall median.
\enumerate{
\item Extract sample metadata (Samples, Groups) from "x$samples".
\item Order columns of y by group or sample name per "selectOrder".
\item Melt the ordered matrix to long format and join with metadata.
\item Plot boxplots with no outliers, colored by group, and include a dashed line at the overall median.
}
}
