% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMetadata.R
\name{checkMetadata}
\alias{checkMetadata}
\title{checkMetadata}
\usage{
checkMetadata(gtfPath, typeFilter)
}
\arguments{
\item{gtfPath}{Character. Path to the directory or file location of the GTF file.}

\item{typeFilter}{Character. The feature type to filter on (e.g., "gene", "exon").}
}
\value{
Character vector of column names in the GTF annotation that are not entirely NA or empty.
}
\description{
Validate and extract non-empty annotation fields from a GTF file.
}
\details{
This function imports a GTF file, filters entries by a specified feature type,
and identifies metadata columns that contain at least one non-missing value.
\enumerate{
\item Imports the GTF into a data frame via "rtracklayer::import()".
\item Filters rows by "type" == typeFilter.
\item Tests each column for all-NA or empty-string entries.
\item Returns names of columns with at least one non-missing, non-empty value.
}
}
