% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g2_snps.R
\name{g2_snps}
\alias{g2_snps}
\title{Estimating g2 from larger datasets, such as SNPs}
\usage{
g2_snps(genotypes, nperm = 0, nboot = 0, CI = 0.95, parallel = FALSE,
  ncores = NULL)
}
\arguments{
\item{genotypes}{\code{data.frame} with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and NA (missing)}

\item{nperm}{number or permutations for to estimate a p-value}

\item{nboot}{number of bootstraps to estimate a confidence interval}

\item{CI}{confidence interval (default to 0.95)}

\item{parallel}{Default is FALSE. If TRUE, bootstrapping and permutation tests are parallelized}

\item{ncores}{Specify number of cores to use for parallelization. By default,
all available cores are used.}
}
\value{
g2_snps returns an object of class "inbreed".
The functions `print` and `plot` are used to print a summary and to plot the distribution of bootstrapped g2 values and CI.

An `inbreed` object from \code{g2_snps} is a list containing the following components:
\item{call}{function call.}
\item{g2}{g2 value}
\item{p_val}{p value from permutation test}
\item{g2_permut}{g2 values from permuted genotypes}
\item{g2_boot}{g2 values from bootstrap samples}
\item{CI_boot}{confidence interval from bootstrap distribution}
\item{se_boot}{standard error of g2 from bootstraps}
\item{nobs}{number of observations}
\item{nloc}{number of markers}
}
\description{
Estimating g2 from larger datasets, such as SNPs
}
\details{
Calculates g2 from SNP datasets. Use convert_raw to convert raw genotypes (with 2 columns per locus) into
         the required format
}
\examples{
# load SNP genotypes in 0 (homozygous), 1 (heterozygous), NA (missing) format.
# low number of bootstraps and permutations for computational reasons.
data(mouse_snps)
(g2_mouse <- g2_snps(mouse_snps, nperm = 10, nboot = 10, CI = 0.95))

# parallelized version for more bootstraps or permutations
\dontrun{
(g2_mouse <- g2_snps(mouse_snps, nperm = 1000, nboot = 1000, 
                     CI = 0.95, parallel = TRUE, ncores = 4))
}

}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com) &
        Mareike Esser (messer@techfak.uni-bielefeld.de)
}
\references{
Hoffman, J.I., Simpson, F., David, P., Rijks, J.M., Kuiken, T., Thorne, M.A.S., Lacey, R.C. & Dasmahapatra, K.K. (2014) High-throughput sequencing reveals inbreeding depression in a natural population.
Proceedings of the National Academy of Sciences of the United States of America, 111: 3775-3780. Doi: 10.1073/pnas.1318945111
}

